﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Inet.Viewer.Data;
using Inet.Viewer.Resources;

namespace Inet.Viewer.WinForms.Prompt
{
    /// <summary>
    /// responsible for panels for prompts with single values and with default values
    /// </summary>
    public partial class SinglePromptFieldWithDefaultValues : PromptControl
    {
        private string oldTextIfNoValueNotChecked;

        /// <summary>
        /// constructor with the given dependencies
        /// </summary>
        /// <param name="promptData">prompt to created this panel for</param>
        public SinglePromptFieldWithDefaultValues(Data.PromptData promptData)
        {
            InitializeComponent();
            this.components = new System.ComponentModel.Container();
            this.ErrorProvider = new System.Windows.Forms.ErrorProvider(this.components);
            this.cmbDefaultValues.TextChanged += new System.EventHandler(this.HandleChanged);
            this.PromptData = promptData;
            List<PromptValue> defaultValues = new List<PromptValue>();
            
            ArrayList values = promptData.DefaultValues;
            PromptValue alreadySelectedValue = promptData.Values;
            string alreadySelectedValueRepr = alreadySelectedValue == null ? null : alreadySelectedValue.StringRepresentation;

            PromptValue valueToSelect = null;
            foreach(PromptValue v in values)
            {
                if (!(v is RangePromptValue))
                {
                    defaultValues.Add(v);
                    if (alreadySelectedValueRepr == v.StringRepresentation)
                    {
                        valueToSelect = v;
                    }
                }
            }
            this.cmbDefaultValues.DataSource = defaultValues;
            this.cmbDefaultValues.DisplayMember = "DisplayString";
            this.cmbDefaultValues.ValueMember = "Value";
            AutoSizeComboBox(cmbDefaultValues);
            if (valueToSelect != null)
            {
                this.cmbDefaultValues.SelectedItem = valueToSelect;
            }
            else if (alreadySelectedValue != null && !promptData.MultipleAllowed)
            {
                this.cmbDefaultValues.SelectedItem = null;
                if (alreadySelectedValue.Value == null)
                {
                    this.chkNoValue.Checked = true;
                }
                else
                {
                    this.cmbDefaultValues.Text = alreadySelectedValue.ValueString;
                }
            }
            if (!this.PromptData.Changeable)
            {
                this.cmbDefaultValues.DropDownStyle = ComboBoxStyle.DropDownList;
                this.chkNoValue.Visible = false;
            }
            else if (this.PromptData.MultipleAllowed || promptData.MinValue != null)
            {
                this.chkNoValue.Visible = false;
            }
            ControlForErrors = chkNoValue.Visible ? (Control)this.chkNoValue : (Control)this.cmbDefaultValues;
        }

        /// <summary>
        /// Called when the "no value" checkbox is checked: sets the value to null
        /// </summary>
        /// <param name="sender">button being checked</param>
        /// <param name="e">args of the event</param>
        internal void chkNoValue_CheckedChanged(object sender, EventArgs e)
        {
            if (this.chkNoValue.Checked)
            {
                oldTextIfNoValueNotChecked = this.cmbDefaultValues.Text;
                this.cmbDefaultValues.Text = '<' + strings.Prompt_None_Long + '>';
                this.cmbDefaultValues.Enabled = false;
            }
            else
            {
                if (oldTextIfNoValueNotChecked == null)
                {
                    oldTextIfNoValueNotChecked = "";
                }
                this.cmbDefaultValues.Text = oldTextIfNoValueNotChecked;
                this.cmbDefaultValues.Enabled = true;
            }
            ValidatePrompt();
            OnValueChanged();
        }
        /// <summary>
        /// <inheritdoc/>
        /// </summary>
        internal override Data.PromptValue Value
        {
            get {
                if (this.chkNoValue.Checked)
                {
                    return new Data.SinglePromptValue(null, "", this.PromptData.Type);
                }
                object obj = this.cmbDefaultValues.SelectedItem;
                string valueString = null;
                if (obj is PromptValue)
                {
                    return obj as PromptValue;
                }
                else if (obj != null)
                {
                    valueString = obj.ToString();
                }
                else
                {
                    valueString = this.cmbDefaultValues.Text;
                }
                return new Data.SinglePromptValue(
                    this.PromptData.type,
                    valueString);
            }
        }
    }
}
